<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class TaxeProduct extends Model 
{

    protected $table = 'taxe_products';
    public $timestamps = true;
    protected $fillable = array('taxe_id', 'status', 'product_id');
    protected $visible = array('taxe_id', 'status', 'product_id');

    public function taxes()
    {
        return $this->belongsTo('App\Models\Tax', 'taxe_id');
    }

    public function products()
    {
        return $this->belongsTo('App\Models\Product', 'product_id');
    }

}